set TheResultsFile to (path to home folder from user domain as text) & "%@"

set LF to ASCII character 10
set quoteMark to "\""

tell application "System Events"
	set UI_enabled to UI elements enabled
end tell
if UI_enabled is false then
	tell application "System Preferences"
		activate
		set current pane to pane "com.apple.preference.universalaccess"
	end tell
else
	tell application "System Preferences"
		quit
	end tell
end if

try
	set results_fd to open for access file TheResultsFile with write permission
on error
	close access file TheResultsFile
	set results_fd to open for access file TheResultsFile with write permission
end try

set eof of results_fd to 0
write "<?xml version=" & quoteMark & "1.0" & quoteMark & " encoding=" & quoteMark & "UTF-8" & quoteMark & "?>" & LF to results_fd
write "<!DOCTYPE plist PUBLIC " & quoteMark & "-//Apple Computer//DTD PLIST 1.0//EN" & quoteMark & " " & quoteMark & "http://www.apple.com/DTDs/PropertyList-1.0.dtd" & quoteMark & ">" & LF to results_fd
write "<plist version=" & quoteMark & "1.0" & quoteMark & ">" & LF to results_fd
write "<dict>" & LF to results_fd
write tab & "<key>uienabled</key>" & LF to results_fd
write tab & "<" & (UI_enabled as string) & "/>" & LF to results_fd
write "</dict>" & LF to results_fd
write "</plist>" & LF to results_fd
close access results_fd

